﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Web;
using System.Web.Mvc;
using BMS.Facade;
using BMS.Facade.Data;
using BMS.Facade.Fault;
using BMS.Utils;
using BMS.Web.App_GlobalResource;

namespace BMS.Web.Controllers
{
    public class BedSummaryReportController : BaseController
    {
        [BasePermissionAuthFilterAttribute(OperationOverride="rep, Bed Summary Report")]
        public ActionResult Index(string p)
        {
            DateTime entryInLogMethodTime = DateTime.UtcNow;
            if (InfoWorld.Tracing.IWTrace.IsEntryEnabled)
            {
                InfoWorld.Tracing.IWTrace.Entry(System.Reflection.MethodBase.GetCurrentMethod(), entryInLogMethodTime);
            }
            try
            {
                IList<IReportInfo> listReports = FacadeManager.ReportsInterface.GetReports(FullUserName);
                IReportInfo report = null;

                if (listReports.Count > 0)
                    report = listReports.Where(rpt => rpt.Name == Constants.BED_SUMMARY_REPORT).FirstOrDefault();

                //Redirect to the report
                if (report == null)
                    throw new ReportRenderException(Constants.BED_SUMMARY_REPORT, Strings.ERR_ReportNotAvailable);
                else
                {
                    if (report.Parameters == null)
                        report.Parameters = new Dictionary<string, string>();

                    report.Parameters.Add(Constants.REPORT_TITLE, Strings.BedSummaryReportTitle + ": " + this.loggedUser.Facility.Name);
                    report.Parameters.Add(Constants.REP_TIME_ZONE_MINUTES_OFFSET, RepTimeZoneMinutesOffset);
                    report.Parameters.Add(Constants.REP_GENERAL_RETURN_PATH, Url.Action("Index", "Home"));
                    report.Parameters.Add(Constants.REP_GENERAL_RETURN_TEXT, Strings.ReturnToHomePage);
                    report.Parameters.Add(Constants.REP_USER_SALT, loggedUser.Salt);
                    report.Parameters.Add(Constants.REP_GENERAL_FACILITY_EXTENSION, this.loggedUser.Facility.Id.extension);

                    FacilitySettings settings = FacadeManager.ConfigurationInterface.GetFacilitySettings(this.loggedUser.Facility.Id);

                    if (!string.IsNullOrEmpty(settings.MedicalCenterID) && settings.IntegratedFacility != null &&
                        settings.IntegratedFacility.code.ToUpper() == "YES")
                        report.Parameters.Add(Constants.REP_SCHEDULED_ADMISSION_MEDICAL_DIVISION, settings.MedicalCenterID);
                    else
                        report.Parameters.Add(Constants.REP_SCHEDULED_ADMISSION_MEDICAL_DIVISION, "");

                    return Redirect(report.Url);
                }
            }
            finally
            {
                if (InfoWorld.Tracing.IWTrace.IsExitEnabled)
                {
                    InfoWorld.Tracing.IWTrace.Exit(System.Reflection.MethodBase.GetCurrentMethod(), DateTime.UtcNow, entryInLogMethodTime);
                }
            }
        }
    }
}
